local SPEED_FACTOR = 0.85

local function reduceSpeed(elevator)
	if elevator == nil then return end
	elevator.Speed = SPEED_FACTOR * elevator.Speed
	elevator.SpeedY = SPEED_FACTOR * elevator.SpeedY
	elevator.SpeedX = SPEED_FACTOR * elevator.SpeedX
end

function main(self)

	if self.State == 0 then
		self.Flags.AlwaysActive, self.DrawFlags.NoDraw = true, true
		self.State = 1
	end

	if self.State == 1 then
		PlayerData().PistolAmmo, PlayerData().MagicAmmo, PlayerData().TNTAmmo = 30, 10, 10
		if GetGameType() == GameType.SinglePlayer then
			PlayerData().Lives = 9
		end
		self.State = 2
	end

	if self.State == 2 then
		local getObject = GetObject
		-- some lava geysers:
		getObject(2253):Destroy()
		getObject(5489):Destroy()
		getObject(1242):Destroy()
		getObject(1243):Destroy()
		getObject(1244):Destroy()
        getObject(1847):Destroy()
        getObject(1846):Destroy()
        getObject(4849):Destroy()
        -- other:
        getObject(3525):Destroy()
        getObject(3603):Destroy()
        getObject(3604):Destroy()
        getObject(3605):Destroy()
		-- 28000 x 13500:
		reduceSpeed(getObject(992))
		reduceSpeed(getObject(759))
		reduceSpeed(getObject(993))
		reduceSpeed(getObject(994))
		reduceSpeed(getObject(995))
		reduceSpeed(getObject(996))
		reduceSpeed(getObject(997))
		reduceSpeed(getObject(998))
		reduceSpeed(getObject(999))
		reduceSpeed(getObject(1000))
		reduceSpeed(getObject(1001))
		reduceSpeed(getObject(1002))
		-- 25000 x 13200:
		reduceSpeed(getObject(679))
		reduceSpeed(getObject(753))
		reduceSpeed(getObject(754))
		reduceSpeed(getObject(680))
		-- 24000 x 14000:
		reduceSpeed(getObject(919))
		reduceSpeed(getObject(921))
		reduceSpeed(getObject(922))
		reduceSpeed(getObject(923))
		-- 26000 x 3500:
		reduceSpeed(getObject(5486))
		reduceSpeed(getObject(5487))
		reduceSpeed(getObject(5485))
		reduceSpeed(getObject(2237))
		-- 27500 x 12000:
		reduceSpeed(getObject(1401))
		reduceSpeed(getObject(1402))
		reduceSpeed(getObject(1344))
		reduceSpeed(getObject(1345))
		reduceSpeed(getObject(1346))
		reduceSpeed(getObject(1343))
		-- 6900 x 10400:
		reduceSpeed(getObject(4710))
		-- 8300 x 11400:
		reduceSpeed(getObject(3054))
		reduceSpeed(getObject(4510))
		reduceSpeed(getObject(4508))
		reduceSpeed(getObject(4509))
		reduceSpeed(getObject(4503))
		reduceSpeed(getObject(4507))
		reduceSpeed(getObject(4506))
		reduceSpeed(getObject(4505))
		-- 16000 x 5200:
		reduceSpeed(getObject(2393))
		reduceSpeed(getObject(2412))
		reduceSpeed(getObject(2395))
		reduceSpeed(getObject(2399))
		reduceSpeed(getObject(2396))
		reduceSpeed(getObject(2398))
		reduceSpeed(getObject(2397))
		reduceSpeed(getObject(2394))
		-- 14600 x 6000:
		reduceSpeed(getObject(2231))
		reduceSpeed(getObject(2232))
		reduceSpeed(getObject(2240))
		reduceSpeed(getObject(2242))
		reduceSpeed(getObject(2230))
		reduceSpeed(getObject(2235))
		-- 27000 x 13700:
		reduceSpeed(getObject(656))
		reduceSpeed(getObject(756))
		reduceSpeed(getObject(757))
		reduceSpeed(getObject(760))
		-- 50500 x 12000:
		reduceSpeed(getObject(4906))
		reduceSpeed(getObject(4907))
		-- 56300 x 11000:
		reduceSpeed(getObject(5181))
		reduceSpeed(getObject(5182))
		-- 9300 x 6000:
		reduceSpeed(getObject(3299))
		reduceSpeed(getObject(3302))
		reduceSpeed(getObject(3300))
		self.State = 3
	end

    -- (Re-)place some tiles:
    if self.State == 3 then
		local action = GetMainPlane()
        -- single pegs:
        action:PlaceTile(466, 77, 236)
        action:PlaceTile(474, 74, 236)
        action:PlaceTile(477, 71, 236)
        action:PlaceTile(480, 68, 236)
        action:PlaceTile(483, 65, 236)
        action:PlaceTile(486, 62, 236)
        -- ladder:
        action:PlaceTile(117, 164, 203)
        action:PlaceTile(403, 226, 234)
        action:PlaceTile(403, 227, 235)
        -- no spikes:
        action:PlaceTile(389, 211, -1)
        action:PlaceTile(390, 211, -1)
        action:PlaceTile(391, 211, -1)
        action:PlaceTile(392, 211, -1)
        action:PlaceTile(393, 211, -1)
        action:PlaceTile(389, 212, 153)
        action:PlaceTile(390, 212, 310)
        action:PlaceTile(391, 212, 154)
        action:PlaceTile(392, 212, 311)
        action:PlaceTile(393, 212, 155)
		-- no spikes:
		action:PlaceTile(248, 78, -1)
        action:PlaceTile(249, 78, -1)
		action:PlaceTile(250, 78, -1)
        action:PlaceTile(251, 78, -1)
		action:PlaceTile(248, 79, 153)
        action:PlaceTile(249, 79, 154)
		action:PlaceTile(250, 79, 154)
        action:PlaceTile(251, 79, 155)
        -- no ceiling spikes:
        action:PlaceTile(681, 193, 461)
        action:PlaceTile(682, 193, -1)
        action:PlaceTile(683, 193, 463)
        self.State = 4
    end

	if self.State == 4 then
		self:Destroy()
	end
end
